// MasterServerLink.cpp: implementation of the CMasterServerLink class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "MasterServerLink.h"
#include <iostream>
#include <fstream>
#include "InitStrings.h"
#include "GlobalStuff.h"

using namespace std;


void set_non_blocking( int fd);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMasterServerLink::CMasterServerLink(const char* server)
{
	initialized=false;

	
	//set up winsock
#ifdef _WIN32
	WORD wVersionRequested;
	WSADATA wsaData;int err; 
	wVersionRequested = MAKEWORD( 2, 2 ); 
	err = WSAStartup( wVersionRequested, &wsaData );if ( err != 0 ) {
		cout << "Couldnt initialize winsock.\n";
		return;
	} 
	/* Confirm that the WinSock DLL supports 2.2.*/
	/* Note that if the DLL supports versions greater    */
	/* than 2.2 in addition to 2.2, it will still return */
	/* 2.2 in wVersion since that is the version we      */
	/* requested.                                        */ 
	if ( LOBYTE( wsaData.wVersion ) != 2 || HIBYTE( wsaData.wVersion ) != 2 ) {
		cout << "Wrong WSA version.\n";
		cout.flush();
		return; 
	}
#endif

	//socket for server masterlink
	if ((udpSocket = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET ){
		cout << "Error initializing feeder udp socket.\n";
		cout.flush();
		return;
	}

	SOCKADDR_IN saMe;

	saMe.sin_family = AF_INET;
	saMe.sin_addr.s_addr = INADDR_ANY; // Let WinSock assign address
	saMe.sin_port = htons(23816);

	if (bind(udpSocket,(struct sockaddr *)&saMe,sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
		closesocket(udpSocket);
		cout << "Error binding feeder udp socket.\n";
		cout.flush();
		return;
	}


    
/*	
	struct  hostent *lpHostEntry;
	unsigned long ul;

	if((ul=inet_addr(server))!=INADDR_NONE){
		lpHostEntry = gethostbyaddr((char*)&ul,sizeof(ul),AF_INET); 
		if (lpHostEntry == NULL)
		{
//			MessageBox(NULL,"Error looking up master server from ip.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
			return;
		}
	} else {
		lpHostEntry = gethostbyname(server);
		if (lpHostEntry == NULL)
		{
//			MessageBox(NULL,"Error looking up master server from dns.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
			return;
		}
	}

	*/
	masterAddress.sin_family = AF_INET;
//	masterAddress.sin_addr = *((LPIN_ADDR)*lpHostEntry->h_addr_list);
	//masterAddress.sin_addr = *((in_addr *)*lpHostEntry->h_addr_list);
	masterAddress.sin_addr.s_addr = g.GetInAddr (server);
	masterAddress.sin_port = htons(23815);	// Port number from command line

	
	//make it nonblocking
//	u_long u=1;
//	ioctlsocket(udpSocket,FIONBIO,&u);
	set_non_blocking(udpSocket);

	lastsend = 0;
	initialized=true;
	cout << "Master server connection started.\n";
}

CMasterServerLink::~CMasterServerLink()
{
	closesocket(udpSocket);

	WSACleanup( );	
}

int
CMasterServerLink::Update()
{
	if(!initialized)
		return -1;
/*	int len=sizeof(sockaddr);
	sockaddr me;
	if(getsockname(udpSocket,&me,&len))
		return -1;
	cout << "My address "  << (unsigned int)(unsigned char)me.sa_data[2] << "." << (unsigned int)(unsigned char)me.sa_data[3] << "." << (unsigned int)(unsigned char)me.sa_data[4] << "." << (unsigned int)(unsigned char)me.sa_data[5] << "\n";
*/	
	std::string s;
	s=initstrings.strings[1]+"\x1"+initstrings.strings[4]+"\x1";
	
	if ((lastsend + 60000 > GetTickCount ()) && (s == laststring))
		return -1;
    lastsend = GetTickCount ();
	laststring = s;

	char temp[300];
	sprintf(temp,"%d\x1%d\x1",g.numFeeders,g.numClients);	
	s += temp;

//	cout << "Sending to master: " << s.c_str () << endl;

	int nRet = sendto(udpSocket,s.c_str(),s.size(),0,(struct sockaddr *)&masterAddress,sizeof(SOCKADDR));

	if(nRet==SOCKET_ERROR){
		cout << "Error sending data to master server "<< WSAGetLastError() << "\n";		
		return -1;
	}
	return 0;
}
