// ServerUdpLink.cpp: implementation of the CServerUdpLink class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "ServerUdpLink.h"
#include "StandardData.h"
#include "GlobalStuff.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CServerUdpLink::CServerUdpLink(int portNum,bool in,bool out)
{
	//set up winsock
#ifdef _WIN32
	WORD wVersionRequested;
	WSADATA wsaData;int err; 
	wVersionRequested = MAKEWORD( 2, 2 ); 
	err = WSAStartup( wVersionRequested, &wsaData );if ( err != 0 ) {
		cout << "Couldnt initialize winsock.\n";
		return;
	} 
	/* Confirm that the WinSock DLL supports 2.2.*/
	/* Note that if the DLL supports versions greater    */
	/* than 2.2 in addition to 2.2, it will still return */
	/* 2.2 in wVersion since that is the version we      */
	/* requested.                                        */ 
	if ( LOBYTE( wsaData.wVersion ) != 2 || HIBYTE( wsaData.wVersion ) != 2 ) {
		cout << "Wrong WSA version.\n";
		cout.flush();
		return; 
	}
#endif

	//listen socket for server
	if ((udpSocket = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET ){
		cout << "Error initializing feeder udp socket.\n";
		cout.flush();
		return;
	}

	SOCKADDR_IN saMe;

	saMe.sin_family = AF_INET;
	//saMe.sin_addr.s_addr = INADDR_ANY; // Let WinSock assign address
	saMe.sin_addr.s_addr = g.localip;
	saMe.sin_port = htons(portNum);

	if (bind(udpSocket,(struct sockaddr *)&saMe,sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
		closesocket(udpSocket);
		cout << "Error binding feeder udp socket.\n";
		cout.flush();
		return;
	}

	//make it nonblocking
//	u_long u=1;
//	ioctlsocket(udpSocket,FIONBIO,&u);
	set_non_blocking(udpSocket);

	
	initialized=true;
	cout << "Feeder udp connection started.\n";
	cout.flush();
}

CServerUdpLink::~CServerUdpLink()
{
	closesocket(udpSocket);

	WSACleanup( );		

}

void
CServerUdpLink::Update()
{
	int ret;
	getpeertype length=sizeof(SOCKADDR);
	SOCKADDR server;
	while(SOCKET_ERROR!=(ret=recvfrom(udpSocket,buf,10000,0,&server,&length))){
		unsigned int serverAddr=*((unsigned int*)&server.sa_data[2]);
		if(g.serverAdress==serverAddr){
			standarddata.AddData(buf,ret);
		} else {
			cout << "Got an unknown packet on server udp port from " << (int)server.sa_data[2] << "." << (int)server.sa_data[3] << "." << (int)server.sa_data[4] << "." << (int)server.sa_data[5] << "\n";
			cout.flush();
		}
	}
}
