// UTProxy.cpp : Defines the entry point for the console application.
//

#include "StdAfx.h"
#include <string>
#include <iostream>
#include "Client.h"
#include "ServerTcpLink.h"
#include "ServerUdpLink.h"
//#include "conio.h"
#include "ClientHandler.h"
#include "MasterServerLink.h"
#include "GlobalStuff.h"
#include "IniFileReader.h"

using namespace std;

int main(int argc, char* argv[])
{
	std::string inifilename;
	std::string serverPass;
	std::string clientPass;
	std::string masterAddress;
	std::string localipstr;
	CMasterServerLink* master=0;

	//Turn of evil signals on linux
	#ifndef _WIN32
	signal (SIGPIPE, SIG_IGN);
	#endif	

	cout << "UTV Server version " << VERSION << endl;

	if(argc==2)
		inifilename=argv[1];
	else 
		inifilename=CFGNAME;

	CIniFileReader inifile(inifilename.c_str());
	serverPass=inifile.GetString("serverpassword");
	clientPass=inifile.GetString("clientpassword");
	g.maxClients=atoi(inifile.GetString("maxclients").c_str());
	int feederPort=atoi(inifile.GetString("feederport").c_str());
	g.clientPort=atoi(inifile.GetString("clientport").c_str());
	g.maxMsgRate=atoi(inifile.GetString("maxmsgrate").c_str());
	g.adminPass=inifile.GetString("adminpassword");
	localipstr=inifile.GetString("localip");

	g.CurId = 42;

	if(feederPort==0)
		feederPort=23810;
	if(g.clientPort==0)
		g.clientPort=23812;

	//cout << endl << "Current configuration:" << endl << "-----------------------" << endl;
	cout << endl;
	cout << "Server password : " << "" << serverPass << "" << endl;
	cout << "Admin password  : " << "" << g.adminPass << "" << endl;
	cout << "Client password : " << "" << clientPass << "" << endl;
	cout << "Max clients     : " << g.maxClients << endl;
	cout << "Feeder port     : " << feederPort << endl;
	cout << "Client port     : " << g.clientPort << endl;
	cout << "Local IP        : " << localipstr << endl;
	
	switch (g.maxMsgRate) {
	case 0: cout << "Max messagerate : unlimited" << endl; break;
	case 1: cout << "Max messagerate : 1 per second" << endl; break;
	default: cout << "Max messagerate : 1 per " << g.maxMsgRate << " seconds" << endl; break;
	}

	cout << endl;


	//Resolve local ip
	if (localipstr.empty()) {
		g.localip = INADDR_ANY;
	}
	else {
		g.localip = g.GetInAddr (localipstr.c_str ());
	}


	//cout << serverPass << " " << clientPass << " " << g.maxClients << " " << feederPort << " " << g.clientPort << endl;
	masterAddress="utvmaster.clan-sy.com";

	//CServerTcpLink* servertcplink=new CServerTcpLink(serverPass.c_str(),true,true);
	CServerTcpLink* servertcplink=new CServerTcpLink(feederPort,serverPass.c_str(),false,false);
	if(!servertcplink->initialized){
		delete servertcplink;
		return -1;
	}

	//CServerUdpLink* serverudplink=new CServerUdpLink(true,true);
	CServerUdpLink* serverudplink=new CServerUdpLink(feederPort+1,false,false);
	CClientHandler* ch=new CClientHandler(clientPass.c_str());

	//	if(!masterAddress.empty())
	//master=new CMasterServerLink(masterAddress.c_str());

	while(1 /* _kbhit()==0 */){
		if(master)
			master->Update();
		servertcplink->Update();
		serverudplink->Update();
		ch->Update();
		cout.flush();
		Sleep(20);
	}
	delete servertcplink;
	delete serverudplink;
	delete master;
	return 0;
}








